/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import android.view.View;
import com.bumptech.glide.ListPreloader;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.ViewTarget;
import java.util.Arrays;

public class ViewPreloadSizeProvider<T>
implements ListPreloader.PreloadSizeProvider<T>,
SizeReadyCallback {
    private int[] size;
    private SizeViewTarget viewTarget;

    public ViewPreloadSizeProvider() {
    }

    public ViewPreloadSizeProvider(View view) {
        this.setView(view);
    }

    @Override
    public int[] getPreloadSize(T item, int adapterPosition, int itemPosition) {
        if (this.size == null) {
            return null;
        }
        return Arrays.copyOf(this.size, this.size.length);
    }

    @Override
    public void onSizeReady(int width, int height) {
        this.size = new int[]{width, height};
        this.viewTarget = null;
    }

    public void setView(View view) {
        if (this.size != null || this.viewTarget != null) {
            return;
        }
        this.viewTarget = new SizeViewTarget(view, this);
    }

    private static final class SizeViewTarget
    extends ViewTarget<View, Object> {
        public SizeViewTarget(View view, SizeReadyCallback callback) {
            super(view);
            this.getSize(callback);
        }

        @Override
        public void onResourceReady(Object resource, GlideAnimation glideAnimation) {
        }
    }
}

