/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request.target;

import android.annotation.TargetApi;
import android.graphics.Point;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.target.BaseTarget;
import com.bumptech.glide.request.target.SizeReadyCallback;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class ViewTarget<T extends View, Z>
extends BaseTarget<Z> {
    private static final String TAG = "ViewTarget";
    private static boolean isTagUsedAtLeastOnce = false;
    private static Integer tagId = null;
    protected final T view;
    private final SizeDeterminer sizeDeterminer;

    public static void setTagId(int tagId) {
        if (ViewTarget.tagId != null || isTagUsedAtLeastOnce) {
            throw new IllegalArgumentException("You cannot set the tag id more than once or change the tag id after the first request has been made");
        }
        ViewTarget.tagId = tagId;
    }

    public ViewTarget(T view) {
        if (view == null) {
            throw new NullPointerException("View must not be null!");
        }
        this.view = view;
        this.sizeDeterminer = new SizeDeterminer((View)view);
    }

    public T getView() {
        return this.view;
    }

    @Override
    public void getSize(SizeReadyCallback cb) {
        this.sizeDeterminer.getSize(cb);
    }

    @Override
    public void setRequest(Request request) {
        this.setTag(request);
    }

    @Override
    public Request getRequest() {
        Object tag = this.getTag();
        Request request = null;
        if (tag != null) {
            if (tag instanceof Request) {
                request = (Request)tag;
            } else {
                throw new IllegalArgumentException("You must not call setTag() on a view Glide is targeting");
            }
        }
        return request;
    }

    private void setTag(Object tag) {
        if (tagId == null) {
            isTagUsedAtLeastOnce = true;
            this.view.setTag(tag);
        } else {
            this.view.setTag(tagId.intValue(), tag);
        }
    }

    private Object getTag() {
        if (tagId == null) {
            return this.view.getTag();
        }
        return this.view.getTag(tagId.intValue());
    }

    public String toString() {
        return "Target for: " + this.view;
    }

    private static class SizeDeterminer {
        private static final int PENDING_SIZE = 0;
        private final View view;
        private final List<SizeReadyCallback> cbs = new ArrayList<SizeReadyCallback>();
        private SizeDeterminerLayoutListener layoutListener;
        private Point displayDimens;

        public SizeDeterminer(View view) {
            this.view = view;
        }

        private void notifyCbs(int width, int height) {
            for (SizeReadyCallback cb : this.cbs) {
                cb.onSizeReady(width, height);
            }
            this.cbs.clear();
        }

        private void checkCurrentDimens() {
            if (this.cbs.isEmpty()) {
                return;
            }
            int currentWidth = this.getViewWidthOrParam();
            int currentHeight = this.getViewHeightOrParam();
            if (!this.isSizeValid(currentWidth) || !this.isSizeValid(currentHeight)) {
                return;
            }
            this.notifyCbs(currentWidth, currentHeight);
            ViewTreeObserver observer = this.view.getViewTreeObserver();
            if (observer.isAlive()) {
                observer.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.layoutListener);
            }
            this.layoutListener = null;
        }

        public void getSize(SizeReadyCallback cb) {
            int currentWidth = this.getViewWidthOrParam();
            int currentHeight = this.getViewHeightOrParam();
            if (this.isSizeValid(currentWidth) && this.isSizeValid(currentHeight)) {
                cb.onSizeReady(currentWidth, currentHeight);
            } else {
                if (!this.cbs.contains(cb)) {
                    this.cbs.add(cb);
                }
                if (this.layoutListener == null) {
                    ViewTreeObserver observer = this.view.getViewTreeObserver();
                    this.layoutListener = new SizeDeterminerLayoutListener(this);
                    observer.addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.layoutListener);
                }
            }
        }

        private int getViewHeightOrParam() {
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            if (this.isSizeValid(this.view.getHeight())) {
                return this.view.getHeight();
            }
            if (layoutParams != null) {
                return this.getSizeForParam(layoutParams.height, true);
            }
            return 0;
        }

        private int getViewWidthOrParam() {
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            if (this.isSizeValid(this.view.getWidth())) {
                return this.view.getWidth();
            }
            if (layoutParams != null) {
                return this.getSizeForParam(layoutParams.width, false);
            }
            return 0;
        }

        private int getSizeForParam(int param, boolean isHeight) {
            if (param == -2) {
                Point displayDimens = this.getDisplayDimens();
                return isHeight ? displayDimens.y : displayDimens.x;
            }
            return param;
        }

        @TargetApi(value=13)
        private Point getDisplayDimens() {
            if (this.displayDimens != null) {
                return this.displayDimens;
            }
            WindowManager windowManager = (WindowManager)this.view.getContext().getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            if (Build.VERSION.SDK_INT >= 13) {
                this.displayDimens = new Point();
                display.getSize(this.displayDimens);
            } else {
                this.displayDimens = new Point(display.getWidth(), display.getHeight());
            }
            return this.displayDimens;
        }

        private boolean isSizeValid(int size) {
            return size > 0 || size == -2;
        }

        private static class SizeDeterminerLayoutListener
        implements ViewTreeObserver.OnPreDrawListener {
            private final WeakReference<SizeDeterminer> sizeDeterminerRef;

            public SizeDeterminerLayoutListener(SizeDeterminer sizeDeterminer) {
                this.sizeDeterminerRef = new WeakReference<SizeDeterminer>(sizeDeterminer);
            }

            public boolean onPreDraw() {
                SizeDeterminer sizeDeterminer;
                if (Log.isLoggable((String)ViewTarget.TAG, (int)2)) {
                    Log.v((String)ViewTarget.TAG, (String)("OnGlobalLayoutListener called listener=" + this));
                }
                if ((sizeDeterminer = (SizeDeterminer)this.sizeDeterminerRef.get()) != null) {
                    sizeDeterminer.checkCurrentDimens();
                }
                return true;
            }
        }
    }
}

